/*---------------------------------------------------------------------------*\

    FILE....: VPBMON.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 1/5/01

    Cponsole driven VPB monitor program for testing VPB cards.

    Compile: gcc vpbmon.cpp -lvpb -g -Wall -o vpbmon -lm -pthread
    Run....: ./vpbmon

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <pthread.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"

int kbhit();
void help();
void *event_thread(void *pv);

#define CH 4
#define PATH "/tmp/"  // RAM-disk with lots of storage under single disk linux

int finish_thread;

int main(int argc, char * argv[])
{
	int	        h[CH];
	int             i,finish,ch,time;
	char            s[VPB_MAX_STR], cmd[VPB_MAX_STR], file[VPB_MAX_STR];
	char            dial[VPB_MAX_STR], pathfile[VPB_MAX_STR];;
	VPB_RECORD      record;
	#ifdef PRINT_EVENTS
	pthread_t       ev_thread;
	#endif
	int bases_pci[] = {0};

	printf("Initialising.........\n");

	vpb_seterrormode(VPB_ERROR_CODE);
	vpb_config(1, bases_pci, "vpbmain_pci.out", VPB_V4PCI);

	for(i=0; i<CH; i++) {
          h[i] = vpb_open(1,i+1);
	  printf("%d\n",i);
	  vpb_sethook_sync(h[i],VPB_ONHOOK);
	}
	finish_thread = 0;
	#ifdef PRINT_EVENTS
	// this can be annoying.....
	pthread_create(&ev_thread, NULL, event_thread, NULL);
	#endif
	printf("\n");
	help();

	finish = 0;
	do {
	  fgets(s, VPB_MAX_STR, stdin);

	  if (s[0] == 'h') { 
	    help();
	  }

	  if (s[0] == 'q') {
 	    finish = 1;
	    finish_thread = 1;
	    printf("type './vpbmon' to start again - bye!\n");
	  }

	  if ((s[0] == 'o') && (s[1] == 'n')) { 
	    sscanf(s, "%s %d\n",cmd, &ch);
	    vpb_sethook_sync(h[ch-1], VPB_ONHOOK);
	    printf("Channel %d on hook...\n",ch);
	  }

	  if ((s[0] == 'o') && (s[1] == 'f')) { 
	    sscanf(s, "%s %d\n",cmd, &ch);
	    vpb_sethook_sync(h[ch-1], VPB_OFFHOOK);
	    printf("Channel %d off hook...\n",ch);
	  }

	  if (s[0] == 'p') { 
	    sscanf(s, "%s %d %s\n",cmd, &ch, file);
	    printf("Playing %s on channel %d...\n",file,ch);

	    sprintf(pathfile,"%s%s",PATH,file);
	    vpb_play_file_sync(h[ch-1], pathfile);
	    printf("finished playing...\n");
	  }

	  if (s[0] == 'r') { 
	    sscanf(s, "%s %d %s %d\n",cmd, &ch, file, &time);
	    record.term_digits = "";
	    record.time_out = time * 1000;
	    sprintf(pathfile,"%s%s",PATH,file);
	    vpb_record_set(h[ch-1], &record);
	    printf("Recording %s on channel %d...\n",file,ch);
	    vpb_record_file_sync(h[ch-1], pathfile, VPB_LINEAR);
	    printf("finished recording...\n");
	  }

	  if (s[0] == 'd') { 
	    sscanf(s, "%s %d %s\n", cmd, &ch, dial);
	    printf("Dialing %s on channel %d...\n",dial,ch);
	    if ((ch >=1) && (ch <=4)) {
		    vpb_dial_sync(h[ch-1], dial);
		    printf("finished dialing...\n");
	    }
	  }

	} while(!finish);

	for(i=0; i<CH; i++) {
	  vpb_sethook_sync(h[i],VPB_ONHOOK);
	  vpb_close(h[i]);
	}

	return 0;
}

void help() {
  
	    printf("h             - Help\n");
	    printf("q             - Quit\n");
	    printf("on [1..4]     - Places channel on hook eg 'on 1'\n");
	    printf("off [1..4]    - Takes channel off hook eg 'off 1'\n");
	    printf("p [1..4] file - play file, eg 'p 1 test'\n");
	    printf("r [1..4] file time(secs) - record file ,"
		   "eg 'r 1 test 4'\n");
	    printf("d [1..4] number - DTMF dial number, e.g. 'd 1 1234'\n");
	    printf("Note: channel 1 is furthest from the mother board\n");
	    printf("If program terminates - type './vpbmon' to restart\n");
	    printf("\n");
}

#ifdef PRINT_EVENTS
void *event_thread(void *pv) {
	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	do {
		// check for events from VPB

		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);
		}
		vpb_sleep(100);
	} while(!finish_thread);

	return NULL;
}
#endif



